/*
 * File: FriendlyCircle.java
 * ================================================================
 * A program that has a friendly circle track the mouse location.
 */
import acm.program.*;
import acm.graphics.*;
import java.awt.*;
import java.awt.event.*;

public class FriendlyCircle extends GraphicsProgram {
	/* The radius of the friendly circle. */
	private static final double CIRCLE_RADIUS = 25;
	
	/* The delay time. */
	private static final double PAUSE_TIME = 1000.0 / 48;
	
	/* The actual circle. */
	private GOval circle;
	
	public void run() {
		createCircle();
		addMouseListeners();
	}
	
	/**
	 * Creates the Friendly Circle and adds it to the canvas.
	 */
	private void createCircle() {
		circle = new GOval(getWidth() / 2.0 - CIRCLE_RADIUS,
				           getHeight() / 2.0 - CIRCLE_RADIUS,
				           2 * CIRCLE_RADIUS,
				           2 * CIRCLE_RADIUS);
		circle.setFilled(true);
		circle.setColor(Color.BLUE);
		add(circle);
	}
	
	/**
	 * Moves the circle to the mouse's location.
	 * 
	 * @param e The MouseEvent with mouse information.
	 */
	public void mouseMoved(MouseEvent e) {
		circle.setLocation(e.getX(), e.getY());
	}
}
